/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.ui;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TabRenameDialog
extends Dialog {
    private Text nameField;
    private String oldValue;
    private String value;
    private boolean valueChanged;

    public TabRenameDialog(Shell parentShell, String currentTabName) {
        super(parentShell);
        this.oldValue = currentTabName;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.value = this.nameField.getText();
            this.valueChanged = !this.value.equals(this.oldValue);
        } else {
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(LogViewerPlugin.getResourceString("dialog.tabrename.title"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameField.setFocus();
        if (this.value != null) {
            this.nameField.setText(this.value);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.nameField = new Text(composite, 16384);
        GridData data = new GridData(1796);
        this.nameField.setLayoutData((Object)data);
        this.nameField.setText(this.oldValue);
        TabRenameDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public boolean isNewValue() {
        return this.valueChanged;
    }

    public String getValue() {
        return this.value;
    }
}

