/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.ui;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.Logger;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class EncodingComboEditor
extends FieldEditor {
    public static int UNLIMITED = -1;
    private Logger logger;
    private Combo combo;
    private int widthInChars = UNLIMITED;

    public EncodingComboEditor(String name, String labelText, int width, Composite parent) {
        this.logger = LogViewerPlugin.getDefault().getLogger();
        this.init(name, labelText);
        this.widthInChars = width;
        this.createControl(parent);
    }

    public EncodingComboEditor(String name, String labelText, Composite parent) {
        this(name, labelText, UNLIMITED, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.combo.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.combo = this.getComboControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.combo);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.combo.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.combo != null) {
            SortedMap<String, Charset> charsets = Charset.availableCharsets();
            Set<String> keys = charsets.keySet();
            Iterator<String> keyIterator = keys.iterator();
            while (keyIterator.hasNext()) {
                Object obj = charsets.get(keyIterator.next());
                try {
                    Method method = obj.getClass().getMethod("displayName", new Class[0]);
                    String encoding = (String)method.invoke(obj, new Object[0]);
                    this.combo.add(encoding);
                }
                catch (Exception e) {
                    this.logger.logError("unable to load all available character encondings for this platform", e);
                }
            }
        }
        this.combo.setText(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        if (this.combo != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.combo.setText(value);
        }
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.getComboControl().getText());
    }

    protected Combo getComboControl() {
        return this.combo;
    }

    protected Combo getComboControl(Composite parent) {
        if (this.combo != null) {
            return this.combo;
        }
        this.combo = new Combo(parent, 131072);
        this.combo.setFont(parent.getFont());
        return this.combo;
    }

    public int getNumberOfControls() {
        return 2;
    }
}

