/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences.rule;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.preferences.Base64;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class RulePreferenceData {
    private int position;
    private boolean enabled;
    private String ruleName;
    private String ruleValue;
    private String matchMode;
    private boolean caseInsensitive;
    private boolean coloringEnabled;
    private RGB backgroundColor;
    private RGB foregroundColor;
    private boolean italic;
    private boolean bold;
    private boolean strikethrough;
    private boolean underline;

    public int getPosition() {
        return this.position;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getRuleNameShort() {
        return LogViewerPlugin.getResourceString(this.ruleName);
    }

    public String getRuleValue() {
        return this.ruleValue;
    }

    public String getMatchMode() {
        return this.matchMode;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean isColoringEnabled() {
        return this.coloringEnabled;
    }

    public RGB getBackgroundColor() {
        return this.backgroundColor;
    }

    public RGB getForegroundColor() {
        return this.foregroundColor;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRuleName(String ruleName) {
        if (ruleName.equalsIgnoreCase("ch.mimo.eclipse.plugin.logfiletools.viewer.rule.WordRule")) {
            ruleName = LogViewerPlugin.getResourceString("WORD");
        } else if (ruleName.equalsIgnoreCase("ch.mimo.eclipse.plugin.logfiletools.viewer.rule.RegExpRule")) {
            ruleName = LogViewerPlugin.getResourceString("JakartaRegExp");
        }
        this.ruleName = ruleName;
    }

    public void setRuleNameShort(String ruleName) {
        this.ruleName = LogViewerPlugin.getResourceString(ruleName);
    }

    public void setRuleValue(String ruleValue) {
        this.ruleValue = ruleValue;
    }

    public void setMatchMode(String matchMode) {
        matchMode = matchMode.toLowerCase().indexOf("find") != -1 ? "find" : "match";
        if (this.getRuleNameShort().toLowerCase().indexOf("word") != -1 || this.getRuleNameShort().toLowerCase().indexOf("jakarta") != -1) {
            matchMode = "find";
        }
        this.matchMode = matchMode;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public void setColoringEnabled(boolean coloringEnabled) {
        this.coloringEnabled = coloringEnabled;
    }

    public void setBackgroundColor(RGB backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setForegroundColor(RGB foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RulePreferenceData)) {
            return false;
        }
        RulePreferenceData data = (RulePreferenceData)object;
        return data.getPosition() == this.getPosition() & data.getBackgroundColor().equals((Object)this.getBackgroundColor()) & data.getForegroundColor().equals((Object)this.getForegroundColor()) & data.getRuleName().equals(this.getRuleName()) & data.getRuleValue().equals(this.getRuleValue()) & data.isCaseInsensitive() == this.isCaseInsensitive() & data.getMatchMode().equals(this.getMatchMode());
    }

    public boolean fillTokens(String value, String delimiter) {
        if (value == null || value.length() <= 0) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, delimiter);
        String positionStr = Base64.decode(tokenizer.nextToken());
        String enabledStr = Base64.decode(tokenizer.nextToken());
        String ruleNameStr = Base64.decode(tokenizer.nextToken());
        String backgroundStr = Base64.decode(tokenizer.nextToken());
        String foregroundStr = Base64.decode(tokenizer.nextToken());
        String ruleValueStr = Base64.decode(tokenizer.nextToken());
        String matchModeStr = null;
        try {
            matchModeStr = tokenizer.nextToken();
            matchModeStr = Base64.decode(matchModeStr);
        }
        catch (NoSuchElementException noSuchElementException) {
            matchModeStr = "match";
        }
        String caseInsensitiveStr = null;
        try {
            caseInsensitiveStr = tokenizer.nextToken();
            caseInsensitiveStr = Base64.decode(caseInsensitiveStr);
        }
        catch (NoSuchElementException noSuchElementException) {
            caseInsensitiveStr = "false";
        }
        this.setPosition(Integer.parseInt(positionStr));
        this.setEnabled(Boolean.valueOf(enabledStr));
        this.setRuleName(ruleNameStr);
        this.setBackgroundColor(StringConverter.asRGB((String)backgroundStr));
        this.setForegroundColor(StringConverter.asRGB((String)foregroundStr));
        this.setRuleValue(ruleValueStr);
        this.setMatchMode(matchModeStr);
        this.setCaseInsensitive(Boolean.valueOf(caseInsensitiveStr));
        return true;
    }
}

