/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences.rule;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.RulePreferenceData;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.RuleFactory;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class RuleDialog
extends StatusDialog {
    private RulePreferenceData data;
    private boolean edit;
    private Button enabledCheckBox;
    private Button caseInsensitiveCheckBox;
    private Button coloringEnabledCheckBox;
    private CCombo ruleTypeCombo;
    private CCombo matchModeCombo;
    private ColorSelector backgroundColorSelector;
    private ColorSelector foregroundColorSelector;
    private Text valueText;

    public RuleDialog(Shell parent, RulePreferenceData data, boolean edit) {
        super(parent);
        this.data = data;
        this.edit = edit;
        this.setShellStyle(this.getShellStyle() | 0x400);
        String title = null;
        title = edit ? LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.edit.title") : LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.new.title");
        this.setTitle(title);
    }

    public Control createDialogArea(Composite parent) {
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout0 = new GridLayout();
        layout0.numColumns = 1;
        layout0.makeColumnsEqualWidth = true;
        layout0.marginWidth = 5;
        layout0.marginHeight = 4;
        pageComponent.setLayout((Layout)layout0);
        GridData data0 = new GridData(768);
        pageComponent.setLayoutData((Object)data0);
        pageComponent.setFont(parent.getFont());
        Group pageGroup1 = new Group(pageComponent, 16);
        pageGroup1.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.lineselection.title"));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.makeColumnsEqualWidth = true;
        layout1.marginWidth = 5;
        layout1.marginHeight = 4;
        pageGroup1.setLayout((Layout)layout1);
        GridData data1 = new GridData(768);
        pageGroup1.setLayoutData((Object)data1);
        pageGroup1.setFont(parent.getFont());
        this.createEnabledCheckBox((Composite)pageGroup1);
        this.createRuleCombo((Composite)pageGroup1);
        this.createValueTextField((Composite)pageGroup1);
        this.createCaseInsensitiveCheckBox((Composite)pageGroup1);
        this.createMatchModeCombo((Composite)pageGroup1);
        Group pageGroup2 = new Group(pageComponent, 16);
        pageGroup2.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.actions.title"));
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        layout2.makeColumnsEqualWidth = true;
        layout2.marginWidth = 5;
        layout2.marginHeight = 4;
        pageGroup2.setLayout((Layout)layout2);
        GridData data2 = new GridData(768);
        pageGroup2.setLayoutData((Object)data2);
        pageGroup2.setFont(parent.getFont());
        Group pageGroup21 = new Group((Composite)pageGroup2, 16);
        pageGroup21.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.highlighting.title"));
        GridLayout layout21 = new GridLayout();
        layout21.numColumns = 2;
        layout21.makeColumnsEqualWidth = true;
        layout21.marginWidth = 5;
        layout21.marginHeight = 4;
        pageGroup21.setLayout((Layout)layout21);
        GridData data21 = new GridData(768);
        pageGroup21.setLayoutData((Object)data21);
        pageGroup21.setFont(parent.getFont());
        this.createColoringEnabledCheckBox((Composite)pageGroup21);
        this.createBackgroundColorSelector((Composite)pageGroup21);
        this.createForegroundColorSelector((Composite)pageGroup21);
        Event event = new Event();
        event.item = null;
        this.ruleTypeCombo.notifyListeners(13, event);
        return pageComponent;
    }

    protected void okPressed() {
        int position = -1;
        boolean rulesOK = this.validateRuleValues();
        if (!rulesOK) {
            return;
        }
        this.data.setPosition(position);
        this.data.setEnabled(this.enabledCheckBox.getSelection());
        this.data.setRuleNameShort(this.ruleTypeCombo.getText());
        this.data.setRuleValue(this.valueText.getText());
        this.data.setCaseInsensitive(this.caseInsensitiveCheckBox.getSelection());
        this.data.setMatchMode(this.matchModeCombo.getText());
        this.data.setColoringEnabled(this.coloringEnabledCheckBox.getSelection());
        this.data.setBackgroundColor(this.backgroundColorSelector.getColorValue());
        this.data.setForegroundColor(this.foregroundColorSelector.getColorValue());
        super.okPressed();
    }

    private boolean validateRuleValues() {
        String title = LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.error.incompletedata.title");
        if (this.ruleTypeCombo.getText() == null || this.ruleTypeCombo.getText().length() <= 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.error.rule.text"));
            return false;
        }
        boolean valid = true;
        String text = LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.error.value.text");
        if (this.valueText.getText() == null || this.valueText.getText().length() <= 0) {
            valid = false;
        } else {
            String ruleClassName = LogViewerPlugin.getResourceString(this.ruleTypeCombo.getText());
            if (RuleFactory.isJavaRegExpRule(ruleClassName)) {
                try {
                    Pattern.compile(this.valueText.getText(), 0);
                }
                catch (PatternSyntaxException ex) {
                    text = String.valueOf(text) + "\n\n" + ex.getLocalizedMessage();
                    valid = false;
                }
            } else {
                try {
                    RECompiler compiler = new RECompiler();
                    compiler.compile(this.valueText.getText());
                }
                catch (RESyntaxException ex) {
                    text = String.valueOf(text) + "\n\n" + ex.getLocalizedMessage();
                    valid = false;
                }
            }
        }
        if (!valid) {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)text);
        }
        return valid;
    }

    private void createEnabledCheckBox(Composite parent) {
        Label comboLabel = new Label(parent, 16384);
        comboLabel.setLayoutData((Object)new GridData(128));
        comboLabel.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.active.label"));
        this.enabledCheckBox = new Button(parent, 32);
        if (this.edit) {
            this.enabledCheckBox.setSelection(this.data.isEnabled());
        } else {
            this.enabledCheckBox.setSelection(true);
        }
    }

    private void createCaseInsensitiveCheckBox(Composite parent) {
        Label comboLabel = new Label(parent, 16384);
        comboLabel.setLayoutData((Object)new GridData(128));
        comboLabel.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.case.label"));
        this.caseInsensitiveCheckBox = new Button(parent, 32);
        if (this.edit) {
            this.caseInsensitiveCheckBox.setSelection(this.data.isCaseInsensitive());
        }
    }

    private void createColoringEnabledCheckBox(Composite parent) {
        Label comboLabel = new Label(parent, 16384);
        comboLabel.setLayoutData((Object)new GridData(128));
        comboLabel.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.coloring.label"));
        this.coloringEnabledCheckBox = new Button(parent, 32);
        if (this.edit) {
            this.coloringEnabledCheckBox.setSelection(this.data.isColoringEnabled());
        }
        this.coloringEnabledCheckBox.setSelection(true);
        this.coloringEnabledCheckBox.setEnabled(false);
    }

    private void createRuleCombo(Composite parent) {
        Label comboLabel = new Label(parent, 16384);
        comboLabel.setLayoutData((Object)new GridData(128));
        comboLabel.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.combo.label"));
        this.ruleTypeCombo = new CCombo(parent, 2048);
        this.ruleTypeCombo.setLayoutData((Object)new GridData(768));
        this.ruleTypeCombo.setEditable(false);
        this.ruleTypeCombo.setItems(RuleFactory.getAllRulesAsComboNames());
        this.ruleTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = RuleDialog.this.ruleTypeCombo.getItem(RuleDialog.this.ruleTypeCombo.getSelectionIndex());
                if (text.toLowerCase().indexOf("word") != -1 || text.toLowerCase().indexOf("jakarta") != -1) {
                    RuleDialog.this.matchModeCombo.setEnabled(false);
                    RuleDialog.this.matchModeCombo.select(0);
                } else {
                    RuleDialog.this.matchModeCombo.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.edit) {
            String[] items = this.ruleTypeCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(this.data.getRuleNameShort())) {
                    this.ruleTypeCombo.select(i);
                    return;
                }
                ++i;
            }
        } else {
            this.ruleTypeCombo.select(0);
        }
    }

    private void createMatchModeCombo(Composite parent) {
        Label comboLabel = new Label(parent, 16384);
        comboLabel.setLayoutData((Object)new GridData(128));
        comboLabel.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.matchmode.label"));
        this.matchModeCombo = new CCombo(parent, 2048);
        this.matchModeCombo.setLayoutData((Object)new GridData(768));
        this.matchModeCombo.setEditable(false);
        String[] matchModes = new String[]{LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.matchmode.entry.find"), LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.matchmode.entry.match")};
        this.matchModeCombo.setItems(matchModes);
        if (this.edit) {
            String[] items = this.matchModeCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].toLowerCase().indexOf(this.data.getMatchMode()) != -1) {
                    this.matchModeCombo.select(i);
                    return;
                }
                ++i;
            }
        }
    }

    private void createBackgroundColorSelector(Composite parent) {
        this.createEmptyTable(parent, 2);
        Label label = new Label(parent, 16384);
        label.setLayoutData((Object)new GridData(128));
        label.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.background.label"));
        this.backgroundColorSelector = new ColorSelector(parent);
        this.backgroundColorSelector.setColorValue(new RGB(255, 255, 255));
        this.backgroundColorSelector.getButton().setLayoutData((Object)new GridData(32));
        if (this.edit) {
            this.backgroundColorSelector.setColorValue(this.data.getBackgroundColor());
        }
    }

    private void createForegroundColorSelector(Composite parent) {
        this.createEmptyTable(parent, 2);
        Label label = new Label(parent, 16384);
        label.setLayoutData((Object)new GridData(128));
        label.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.foreground.label"));
        this.foregroundColorSelector = new ColorSelector(parent);
        this.foregroundColorSelector.setColorValue(new RGB(0, 0, 0));
        this.foregroundColorSelector.getButton().setLayoutData((Object)new GridData(32));
        if (this.edit) {
            this.foregroundColorSelector.setColorValue(this.data.getForegroundColor());
        }
    }

    protected Table createEmptyTable(Composite composite, int horizontalSpan) {
        Table table = new Table(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.verticalSpan = 1;
        gridData.widthHint = 1;
        gridData.heightHint = 1;
        table.setLayoutData((Object)gridData);
        table.setBackground(composite.getBackground());
        return table;
    }

    private void createValueTextField(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setLayoutData((Object)new GridData(128));
        label.setText(LogViewerPlugin.getResourceString("preferences.ruleseditor.dialog.value.label"));
        this.valueText = new Text(parent, 2048);
        this.valueText.setLayoutData((Object)new GridData(768));
        if (this.edit) {
            this.valueText.setText(this.data.getRuleValue());
        }
    }
}

