/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences.rule;

import de.anbos.eclipse.logviewer.plugin.preferences.rule.RulePreferenceData;
import de.anbos.eclipse.logviewer.plugin.preferences.rule.RuleStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ItemMover
implements SelectionListener {
    private Table table;
    private RuleStore store;
    private RulePreferenceData currentSelection;

    public ItemMover(Table table, RuleStore store) {
        this.table = table;
        this.store = store;
        table.addSelectionListener((SelectionListener)this);
    }

    public void moveCurrentSelectionUp() {
        if (this.currentSelection == null) {
            return;
        }
        RulePreferenceData previousElement = this.store.getPreviousElement(this.currentSelection);
        if (previousElement == null) {
            return;
        }
        int newPosition = previousElement.getPosition();
        int oldPosition = this.currentSelection.getPosition();
        previousElement.setPosition(oldPosition);
        this.currentSelection.setPosition(newPosition);
    }

    public void moveCurrentSelectionDown() {
        if (this.currentSelection == null) {
            return;
        }
        RulePreferenceData nextElement = this.store.getNextElement(this.currentSelection);
        if (nextElement == null) {
            return;
        }
        int newPosition = nextElement.getPosition();
        int oldPosition = this.currentSelection.getPosition();
        nextElement.setPosition(oldPosition);
        this.currentSelection.setPosition(newPosition);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        TableItem item = null;
        try {
            item = this.table.getSelection()[0];
        }
        catch (Throwable throwable) {
            this.currentSelection = null;
            return;
        }
        if (item == null || !(item.getData() instanceof RulePreferenceData)) {
            this.currentSelection = null;
            return;
        }
        this.currentSelection = (RulePreferenceData)item.getData();
    }
}

