/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences;

import de.anbos.eclipse.logviewer.plugin.preferences.rule.RulePreferenceData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RuleItemReadWriter {
    private static final String NODE_ROOT = "rule-items";
    private static final String NODE_ITEM = "item";
    private static final String NODE_RULE = "rule";
    private static final String NODE_BACKGROUND = "background";
    private static final String NODE_FOREGROUND = "foreground";
    private static final String NODE_VALUE = "value";
    private static final String NODE_MATCHMODE = "matchmode";
    private static final String NODE_CASEINSENSITIVE = "case-insensitive";
    private static final String ATTR_POSITION = "position";
    private static final String ATTR_CHECKED = "checked";

    public RulePreferenceData[] read(InputStream stream) throws IOException {
        return this.read(new InputSource(stream));
    }

    public void write(RulePreferenceData[] data, OutputStream stream) throws IOException {
        this.write(data, new StreamResult(stream));
    }

    private RulePreferenceData[] read(InputSource input) throws IOException {
        boolean errorInParsing = false;
        ArrayList<RulePreferenceData> itemArray = new ArrayList<RulePreferenceData>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(input);
            NodeList items = document.getElementsByTagName(NODE_ITEM);
            int i = 0;
            while (i != items.getLength()) {
                int fieldCounter = 0;
                RulePreferenceData data = new RulePreferenceData();
                Node item = items.item(i);
                NamedNodeMap attributes = item.getAttributes();
                Node positionAttr = attributes.getNamedItem(ATTR_POSITION);
                if (positionAttr == null) {
                    errorInParsing = true;
                    break;
                }
                try {
                    data.setPosition(Integer.parseInt(positionAttr.getNodeValue()));
                    ++fieldCounter;
                }
                catch (NumberFormatException e) {
                    throw new IOException(e.getMessage());
                }
                Node checkedAttr = attributes.getNamedItem(ATTR_CHECKED);
                if (checkedAttr == null) {
                    errorInParsing = true;
                    break;
                }
                if (checkedAttr.getNodeValue().equals(Boolean.toString(true))) {
                    data.setEnabled(true);
                    ++fieldCounter;
                } else {
                    if (!checkedAttr.getNodeValue().equals(Boolean.toString(false))) {
                        errorInParsing = true;
                        break;
                    }
                    data.setEnabled(false);
                    ++fieldCounter;
                }
                NodeList nodes = item.getChildNodes();
                int n = 0;
                while (n < nodes.getLength()) {
                    Node node = nodes.item(n);
                    if (node.getNodeName().equals(NODE_RULE)) {
                        data.setRuleName(this.extractStringValueFromNode(node));
                        ++fieldCounter;
                    } else if (node.getNodeName().equals(NODE_BACKGROUND)) {
                        data.setBackgroundColor(StringConverter.asRGB((String)this.extractStringValueFromNode(node)));
                        ++fieldCounter;
                    } else if (node.getNodeName().equals(NODE_FOREGROUND)) {
                        data.setForegroundColor(StringConverter.asRGB((String)this.extractStringValueFromNode(node)));
                        ++fieldCounter;
                    } else if (node.getNodeName().equals(NODE_VALUE)) {
                        data.setRuleValue(this.extractStringValueFromNode(node));
                        ++fieldCounter;
                    } else if (node.getNodeName().equals(NODE_MATCHMODE)) {
                        data.setMatchMode(this.extractStringValueFromNode(node));
                        ++fieldCounter;
                    } else if (node.getNodeName().equals(NODE_CASEINSENSITIVE)) {
                        if (this.extractStringValueFromNode(node).equals(Boolean.toString(true))) {
                            data.setCaseInsensitive(true);
                        } else {
                            data.setCaseInsensitive(false);
                        }
                        ++fieldCounter;
                    }
                    ++n;
                }
                if (fieldCounter != 8) {
                    if (fieldCounter >= 8 || fieldCounter < 6) {
                        errorInParsing = true;
                        break;
                    }
                    data.setMatchMode("match");
                    if (fieldCounter == 6) {
                        data.setCaseInsensitive(false);
                    }
                }
                itemArray.add(data);
                ++i;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t != null) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(e.getMessage());
        }
        if (!errorInParsing) {
            return itemArray.toArray(new RulePreferenceData[itemArray.size()]);
        }
        throw new IOException("unable to parse the xml");
    }

    private void write(RulePreferenceData[] data, StreamResult streamResult) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootNode = document.createElement(NODE_ROOT);
            document.appendChild(rootNode);
            int i = 0;
            while (i < data.length) {
                RulePreferenceData item = data[i];
                Element itemNode = document.createElement(NODE_ITEM);
                rootNode.appendChild(itemNode);
                NamedNodeMap attributes = itemNode.getAttributes();
                Attr positionAttr = document.createAttribute(ATTR_POSITION);
                positionAttr.setValue(Integer.toString(item.getPosition()));
                attributes.setNamedItem(positionAttr);
                Attr checkedAttr = document.createAttribute(ATTR_CHECKED);
                checkedAttr.setValue(Boolean.toString(item.isEnabled()));
                attributes.setNamedItem(checkedAttr);
                Element ruleNode = document.createElement(NODE_RULE);
                itemNode.appendChild(ruleNode);
                Text ruleValue = document.createTextNode(item.getRuleName());
                ruleNode.appendChild(ruleValue);
                Element backgroundNode = document.createElement(NODE_BACKGROUND);
                itemNode.appendChild(backgroundNode);
                Text backgroundValue = document.createTextNode(StringConverter.asString((RGB)item.getBackgroundColor()));
                backgroundNode.appendChild(backgroundValue);
                Element foregroundNode = document.createElement(NODE_FOREGROUND);
                itemNode.appendChild(foregroundNode);
                Text foregroundValue = document.createTextNode(StringConverter.asString((RGB)item.getForegroundColor()));
                foregroundNode.appendChild(foregroundValue);
                Element valueNode = document.createElement(NODE_VALUE);
                itemNode.appendChild(valueNode);
                CDATASection valueCDataSection = document.createCDATASection(item.getRuleValue());
                valueNode.appendChild(valueCDataSection);
                Element matchModeNode = document.createElement(NODE_MATCHMODE);
                itemNode.appendChild(matchModeNode);
                Text matchModeValue = document.createTextNode(item.getMatchMode());
                matchModeNode.appendChild(matchModeValue);
                Element caseInsensitiveNode = document.createElement(NODE_CASEINSENSITIVE);
                itemNode.appendChild(caseInsensitiveNode);
                Text caseInsensitiveValue = document.createTextNode(Boolean.toString(item.isCaseInsensitive()));
                caseInsensitiveNode.appendChild(caseInsensitiveValue);
                ++i;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, streamResult);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            Assert.isTrue((boolean)false);
        }
    }

    private String extractStringValueFromNode(Node node) {
        StringBuffer buffer = new StringBuffer();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i != children.getLength()) {
            String value = children.item(i).getNodeValue();
            if (value != null) {
                buffer.append(value);
            }
            ++i;
        }
        return buffer.toString();
    }
}

