/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences;

import de.anbos.eclipse.logviewer.plugin.LogFile;

public class HistoryFile {
    private String path;
    private LogFile.LogFileType type;
    private int count;

    public HistoryFile(String path, LogFile.LogFileType type, int count) {
        this.path = path;
        this.type = type;
        this.count = count;
    }

    public String getPath() {
        return this.path;
    }

    public LogFile.LogFileType getType() {
        return this.type;
    }

    public String getFileName() {
        return this.path.substring(this.path.lastIndexOf(System.getProperty("file.separator")) + 1);
    }

    public String getName() {
        String name = null;
        if (this.type == LogFile.LogFileType.LOGFILE_SYSTEM_FILE) {
            name = "File: ";
        } else if (this.type == LogFile.LogFileType.LOGFILE_ECLIPSE_CONSOLE) {
            name = "Console: ";
        }
        return String.valueOf(name) + this.getFileName();
    }

    public int getCount() {
        return this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public boolean equals(Object object) {
        if (object instanceof HistoryFile) {
            HistoryFile file = (HistoryFile)object;
            return file.getPath().equals(this.getPath()) && file.getType() == this.getType();
        }
        return false;
    }
}

