/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.file.document;

import de.anbos.eclipse.logviewer.plugin.LogFile;
import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.file.BackgroundReader;
import de.anbos.eclipse.logviewer.plugin.file.IFileChangedListener;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;

public class LogDocument
extends AbstractDocument
implements IFileChangedListener {
    private LogFile file;
    private Charset charset;
    private String encoding;
    private BackgroundReader reader;
    private boolean monitor;
    private int backlogLines;

    public LogDocument(LogFile file, String encoding) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, PartInitException {
        if (file.getEncoding() == null) {
            file.setEncoding(encoding);
        }
        this.file = file;
        this.encoding = file.getEncoding();
        this.charset = Charset.forName(file.getEncoding());
        IPreferenceStore store = LogViewerPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)new PropertyChangeListener());
        this.backlogLines = store.getInt("BACKLOG");
        this.setTextStore((ITextStore)new GapTextStore(50, 300, 1.0f));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
        this.reader = new BackgroundReader(file.getFileType(), file.getFileName(), this.charset, this);
    }

    public void setEncoding(String encoding) {
        this.setMonitor(false);
        this.file.setEncoding(encoding);
        this.encoding = encoding;
        this.charset = Charset.forName(encoding);
        try {
            this.reader = new BackgroundReader(this.file.getFileType(), this.file.getFileName(), this.charset, this);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        this.setMonitor(true);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void synchronize() {
        this.setMonitor(false);
        this.getStore().set("");
        this.getTracker().set("");
        try {
            this.reader = new BackgroundReader(this.file.getFileType(), this.file.getFileName(), this.charset, this);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        this.setMonitor(true);
    }

    public void setBacklog(int lines) {
        this.backlogLines = lines;
    }

    public void setMonitor(boolean monitorIn) {
        if (monitorIn && !this.monitor) {
            this.getStore().set("");
            this.getTracker().set("");
        }
        this.monitor = monitorIn;
        this.reader.setMonitorStatus(this.monitor);
        this.file.setMonitor(this.monitor);
    }

    public boolean isMonitor() {
        return this.monitor;
    }

    public void contentAboutToBeChanged() {
        Runnable runnable = new Runnable(){

            public void run() {
                DocumentEvent event = new DocumentEvent((IDocument)LogDocument.this, LogDocument.this.getStore().getLength(), 0, "");
                LogDocument.this.fireDocumentAboutToBeChanged(event);
            }
        };
        if (Display.getDefault() != null) {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public void fileChanged(char[] content, boolean isFirstTimeRead) {
        Runnable runnable = new Runnable(){

            public void run() {
                String text = new String(content);
                int offset = LogDocument.this.calculateBacklogOffset();
                String currentText = LogDocument.this.getStore().get(offset, LogDocument.this.getStore().getLength() - offset);
                currentText = currentText.concat(text);
                LogDocument.this.getStore().set(currentText);
                LogDocument.this.getTracker().set(currentText);
                if (isFirstTimeRead) {
                    offset = LogDocument.this.calculateBacklogOffset();
                    currentText = LogDocument.this.getStore().get(offset, LogDocument.this.getStore().getLength() - offset);
                    LogDocument.this.getStore().set(currentText);
                    LogDocument.this.getTracker().set(currentText);
                }
                DocumentEvent event = new DocumentEvent((IDocument)LogDocument.this, LogDocument.this.getStore().getLength(), content.length, text);
                LogDocument.this.fireDocumentChanged(event);
            }
        };
        if (Display.getDefault() != null) {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public LogFile getFile() {
        return this.file;
    }

    private int calculateBacklogOffset() {
        int numberOfLines = this.getTracker().getNumberOfLines();
        if (numberOfLines <= this.backlogLines) {
            return 0;
        }
        int overflow = numberOfLines - this.backlogLines;
        try {
            return this.getTracker().getLineOffset(overflow);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("BACKLOG")) {
                LogDocument.this.backlogLines = LogViewerPlugin.getDefault().getPreferenceStore().getInt("BACKLOG");
            }
        }
    }
}

