/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.action.delegate;

import de.anbos.eclipse.logviewer.plugin.LogFile;
import de.anbos.eclipse.logviewer.plugin.LogViewer;
import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.action.delegate.ILogViewerActionDelegate;
import de.anbos.eclipse.logviewer.plugin.preferences.FileHistoryTracker;
import de.anbos.eclipse.logviewer.plugin.preferences.HistoryFile;
import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileOpenViewActionDelegate
implements ILogViewerActionDelegate {
    private String parentPath = null;
    private boolean fileOpened = false;
    private LogFile.LogFileType type;

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public boolean isFileOpened() {
        return this.fileOpened;
    }

    public void run(LogViewer view, Shell shell) {
        this.fileOpened = false;
        String typeStr = null;
        this.type = LogFile.LogFileType.LOGFILE_SYSTEM_FILE;
        if (this.type == LogFile.LogFileType.LOGFILE_SYSTEM_FILE) {
            Object[] file_list;
            String filterExtensions = LogViewerPlugin.getDefault().getPreferenceStore().getString("FILTER_EXTENSIONS");
            FileDialog dialog = new FileDialog(shell, 4098);
            String[] extensions = new String[]{filterExtensions, "*.*"};
            if (this.parentPath == null && (file_list = FileHistoryTracker.getInstance().getFiles().toArray()).length >= 1) {
                HistoryFile history_file = (HistoryFile)file_list[file_list.length - 1];
                File file = new File(history_file.getPath());
                this.parentPath = file.isDirectory() ? file.toString() : file.getParent();
            }
            dialog.setFilterPath(this.parentPath);
            dialog.setFilterExtensions(extensions);
            dialog.setFilterIndex(0);
            String path = dialog.open();
            if (path != null) {
                File tempFile = new File(path);
                path = tempFile.isDirectory() ? tempFile.toString() : tempFile.getParent();
                String[] selectedFiles = dialog.getFileNames();
                int i = 0;
                while (i < selectedFiles.length) {
                    String fileStr;
                    String string = fileStr = path.endsWith(File.separator) ? String.valueOf(path) + selectedFiles[i] : String.valueOf(path) + File.separator + selectedFiles[i];
                    if (!view.checkAndOpenFile(this.type, fileStr, true)) {
                        this.fileOpened = true;
                    }
                    ++i;
                }
            }
        } else if (this.type == LogFile.LogFileType.LOGFILE_ECLIPSE_CONSOLE && !view.checkAndOpenFile(this.type, typeStr, true)) {
            this.fileOpened = true;
        }
    }
}

