/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;

public class UIImages {
    private static URL ICON_BASE_URL = null;
    private static ImageRegistry imageRegistry = null;

    static {
        String pathSuffix = "icons/";
        try {
            ICON_BASE_URL = new URL(LogViewerPlugin.getDefault().getBundle().getEntry("/"), pathSuffix);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIImages.getImageRegistry().getDescriptor(key);
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            UIImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    private static ImageRegistry initializeImageRegistry() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        imageRegistry = new ImageRegistry(display);
        UIImages.declareRegistryImage("IMG_OPEN_FILE_ACTIVE", "active/open_active.gif");
        UIImages.declareRegistryImage("IMG_OPEN_FILE_PASSIVE", "passive/open_passive.gif");
        UIImages.declareRegistryImage("IMG_CLEAR_HISTORY_ACTIVE", "active/removeall_active.gif");
        UIImages.declareRegistryImage("IMG_CLEAR_HISTORY_PASSIVE", "passive/removeall_passive.gif");
        UIImages.declareRegistryImage("IMG_PREFERENCES_ACTIVE", "active/prop_ps.gif");
        UIImages.declareRegistryImage("IMG_PREFERENCES_PASSIVE", "passive/prop_ps.gif");
        UIImages.declareRegistryImage("IMG_CLOSE_FILE_ACTIVE", "active/remove_active.gif");
        UIImages.declareRegistryImage("IMG_CLOSE_FILE_PASSIVE", "passive/remove_passive.gif");
        UIImages.declareRegistryImage("IMG_CLOSEALL_ACTIVE", "active/removeall_active.gif");
        UIImages.declareRegistryImage("IMG_CLOSEALL_PASSIVE", "passive/removeall_passive.gif");
        UIImages.declareRegistryImage("IMG_REFRESH_FILE_ACTIVE", "active/refresh_active.gif");
        UIImages.declareRegistryImage("IMG_REFRESH_FILE_PASSIVE", "passive/refresh_passive.gif");
        UIImages.declareRegistryImage("IMG_START_TAIL_ACTIVE", "active/start_active.gif");
        UIImages.declareRegistryImage("IMG_START_TAIL_PASSIVE", "passive/start_passive.gif");
        UIImages.declareRegistryImage("IMG_START_ALL_TAIL_ACTIVE", "active/start_all_active.gif");
        UIImages.declareRegistryImage("IMG_START_ALL_TAIL_PASSIVE", "passive/start_all_passive.gif");
        UIImages.declareRegistryImage("IMG_STOP_TAIL_ACTIVE", "active/stop_active.gif");
        UIImages.declareRegistryImage("IMG_STOP_TAIL_PASSIVE", "passive/stop_passive.gif");
        UIImages.declareRegistryImage("IMG_STOP_ALL_TAIL_ACTIVE", "active/stop_all_active.gif");
        UIImages.declareRegistryImage("IMG_STOP_ALL_TAIL_PASSIVE", "passive/stop_all_passive.gif");
        UIImages.declareRegistryImage("IMG_FILTER_ACTIVE", "active/filter_active.gif");
        UIImages.declareRegistryImage("IMG_FILTER_PASSIVE", "passive/filter_passive.gif");
        UIImages.declareRegistryImage("IMG_ENCODING_ACTIVE", "active/encoding_active.gif");
        UIImages.declareRegistryImage("IMG_FIND_ACTIVE", "active/find_obj_active.gif");
        UIImages.declareRegistryImage("IMG_FIND_PASSIVE", "passive/find_obj_passive.gif");
        UIImages.declareRegistryImage("IMG_RENAME_ACTIVE", "active/rename_active.gif");
        UIImages.declareRegistryImage("IMG_RENAME_PASSIVE", "passive/rename_passive.gif");
        UIImages.declareRegistryImage("IMG_COPY_ACTIVE", "active/copy_active.gif");
        UIImages.declareRegistryImage("IMG_COPY_PASSIVE", "active/copy_passive.gif");
        UIImages.declareRegistryImage("IMG_LOG_VIEWER", "logviewer.gif");
        return imageRegistry;
    }

    private static void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)UIImages.makeIconFileURL(path));
        }
        catch (MalformedURLException me) {
            LogViewerPlugin.getDefault().showErrorMessage(me);
        }
        imageRegistry.put(key, desc);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }
}

