/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin;

import de.anbos.eclipse.logviewer.plugin.Logger;
import de.anbos.eclipse.logviewer.plugin.LoggerImpl;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LogViewerPlugin
extends AbstractUIPlugin {
    private static LogViewerPlugin plugin;
    private ResourceBundle resourceBundle;
    private Logger logger;

    public LogViewerPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("de.anbos.eclipse.logviewer.plugin.LogfileUIMessages");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static LogViewerPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = LogViewerPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getResourceString(String key, Object[] args) {
        return MessageFormat.format(LogViewerPlugin.getResourceString(key), args);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.loadDefaultPluginPreferences(this.getPreferenceStore());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new LoggerImpl(this.getLog(), this.getBundle().getSymbolicName());
        }
        return this.logger;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void showErrorMessage(String message) {
        IWorkbenchWindow window = LogViewerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            MessageDialog.openError((Shell)window.getShell().getShell(), (String)LogViewerPlugin.getResourceString("error.fatal.title"), (String)message);
        }
    }

    public void showErrorMessage(Throwable throwable) {
        this.showErrorMessage(String.valueOf(throwable.getClass().getName()) + " " + throwable.getMessage());
    }

    public void showInfoMessage(String message) {
        IWorkbenchWindow window = LogViewerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            MessageDialog.openInformation((Shell)window.getShell().getShell(), (String)LogViewerPlugin.getResourceString("error.info.title"), (String)message);
        }
    }

    public void showWarningMessage(String message) {
        IWorkbenchWindow window = LogViewerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            MessageDialog.openWarning((Shell)window.getShell().getShell(), (String)LogViewerPlugin.getResourceString("error.warning.title"), (String)message);
        }
    }

    private void loadDefaultPluginPreferences(IPreferenceStore store) {
        store.setDefault("BACKLOG", 4000);
        store.setDefault("BUFFER", 1024);
        store.setDefault("READWAIT", 250);
        store.setDefault("ENCODING", System.getProperty("file.encoding"));
        store.setDefault("WORD_WRAP", false);
        store.setDefault("SHOW_WHEN_UPDATED", false);
        store.setDefault("FILTER_EXTENSIONS", "*.log;*.txt;*.er?");
        store.setDefault("SHOW_TOP_OF_FILE", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"CURSOR_LINE_COLOR", (RGB)new RGB(192, 192, 192));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"EDITOR_FONT_SYLE", (FontData[])JFaceResources.getDefaultFont().getFontData());
    }
}

