/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class GFortranErrorParser
implements IErrorParser {
    private static final int MAX_LINES_IN_ERROR_MESSAGE = 10;
    private static final Pattern startLine = Pattern.compile("^(In file )?(.+):([0-9]+)(\\.([0-9]+))?:$");
    private static final Pattern errorLine = Pattern.compile("^(Fatal )?Error: .*");
    private static final Pattern warningLine = Pattern.compile("^Warning: .*");
    private IErrorParser currentState = new WaitForStartLine();

    public boolean processLine(String line, ErrorParserManager eoParser) {
        return this.currentState.processLine(line, eoParser);
    }

    private class AccumulateErrorMessageLines
    implements IErrorParser {
        private String filename;
        private int lineNumber;
        private StringBuffer errorMessage = new StringBuffer();
        private int linesAccumulated = 1;

        public AccumulateErrorMessageLines(String filename, int lineNumber, String line) {
            this.filename = filename;
            this.lineNumber = lineNumber;
            this.errorMessage.append(line);
        }

        public boolean processLine(String line, ErrorParserManager eoParser) {
            ++this.linesAccumulated;
            Matcher errorMatcher = errorLine.matcher(line);
            Matcher warningMatcher = warningLine.matcher(line);
            if (errorMatcher.matches()) {
                this.errorMessage.append(" ");
                this.errorMessage.append(line);
                this.addMarker(eoParser, true);
                return true;
            }
            if (warningMatcher.matches()) {
                this.errorMessage.append(" ");
                this.errorMessage.append(line);
                this.addMarker(eoParser, false);
                return true;
            }
            if (this.linesAccumulated > 10) {
                GFortranErrorParser.this.currentState = new WaitForStartLine();
                return false;
            }
            return false;
        }

        private void addMarker(ErrorParserManager eoParser, boolean isError) {
            IFile file = this.findFile(eoParser);
            eoParser.generateMarker((IResource)file, this.lineNumber, this.errorMessage.toString(), isError ? 2 : 1, null);
            GFortranErrorParser.this.currentState = new WaitForStartLine();
        }

        private IFile findFile(ErrorParserManager eoParser) {
            IFile result = eoParser.findFileName(this.filename);
            if (result != null) {
                return result;
            }
            if (this.filename.startsWith("../") || this.filename.startsWith("..\\")) {
                return eoParser.findFileName(this.filename.substring(3));
            }
            return null;
        }
    }

    private class WaitForStartLine
    implements IErrorParser {
        private WaitForStartLine() {
        }

        public boolean processLine(String line, ErrorParserManager eoParser) {
            Matcher startLineMatcher = startLine.matcher(line);
            if (startLineMatcher.matches()) {
                String filename = startLineMatcher.group(2);
                int lineNumber = Integer.parseInt(startLineMatcher.group(3));
                GFortranErrorParser.this.currentState = new AccumulateErrorMessageLines(filename, lineNumber, line);
            }
            return false;
        }
    }
}

