/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.license;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.license.LicenseDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;

public class LicensePlugin
extends Plugin {
    private static LicensePlugin plugin;
    private static boolean licenseStat;
    private static boolean licenseAsked;
    private static final String licenseFile = "unisys_ca_license.txt";
    private static final String allinoneFlag = "unisys_allinone.txt";
    private static final String licenseAgreed = "unisys_ca_license_ok.txt";
    private static final String PROP_EXITCODE = "eclipse.exitcode";
    private static final String PROP_EXITDATA = "eclipse.exitdata";
    private static final String requiredVersion = "1.5";

    static {
        licenseStat = false;
        licenseAsked = false;
    }

    public LicensePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static LicensePlugin getDefault() {
        return plugin;
    }

    public static synchronized boolean checkLicense() {
        if (!licenseAsked) {
            licenseAsked = true;
            Display dd = Display.getDefault();
            dd.syncExec(new Runnable(){

                @Override
                public void run() {
                    Identifier required;
                    String availableVersion = System.getProperty("java.version");
                    Identifier available = new Identifier(availableVersion);
                    boolean compatible = available.isGreaterEqualTo(required = new Identifier(LicensePlugin.requiredVersion));
                    if (!compatible) {
                        System.getProperties().put(LicensePlugin.PROP_EXITCODE, "14");
                        System.getProperties().put(LicensePlugin.PROP_EXITDATA, "Required Java version: 1.5. Available: " + availableVersion + '.');
                        MessageDialog.openError(null, (String)Messages.getString((String)"LicensePlugin.licenseDialogTitle"), (String)(String.valueOf(Messages.getString((String)"LicensePlugin.versionConflict", (String)LicensePlugin.requiredVersion, (String)availableVersion)) + "\r\n" + Messages.getString((String)"LicensePlugin.simpleExit")));
                        System.exit(0);
                    }
                }
            });
            try {
                File f1 = LicensePlugin.getLicenseAgreed();
                licenseStat = f1.exists();
                if (licenseStat) {
                    return licenseStat;
                }
                boolean allInOne = true;
                URL url = LicensePlugin.getDefault().getBundle().getEntry("/unisys_allinone.txt");
                try {
                    InputStream is = null;
                    if (url != null) {
                        is = url.openStream();
                    }
                    allInOne = is != null;
                }
                catch (Exception exception) {
                    allInOne = false;
                }
                if (!allInOne) {
                    LicensePlugin.markLicense();
                    licenseStat = true;
                    licenseAsked = true;
                    return licenseStat;
                }
            }
            catch (Exception exception) {}
            dd = Display.getDefault();
            dd.syncExec(new Runnable(){

                @Override
                public void run() {
                    String msgtext = LicensePlugin.getLicenseText();
                    if (msgtext != null && msgtext != "") {
                        LicenseDialog ld = new LicenseDialog(Messages.getString((String)"LicensePlugin.licenseDialogTitle"), msgtext);
                        int mdstat = ld.open();
                        licenseStat = mdstat == 0;
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"LicensePlugin.licenseDialogTitle"), (String)Messages.getString((String)"LicensePlugin.licenseFileMissing"));
                        licenseStat = false;
                    }
                    if (!licenseStat) {
                        MessageDialog.openWarning(null, (String)Messages.getString((String)"LicensePlugin.licenseDialogTitle"), (String)Messages.getString((String)"LicensePlugin.exitNow"));
                        System.exit(0);
                    } else {
                        LicensePlugin.markLicense();
                        licenseStat = true;
                        licenseAsked = true;
                    }
                }
            });
        }
        return licenseStat;
    }

    private static String getLicenseText() {
        String licenseText = null;
        URL url = LicensePlugin.getDefault().getBundle().getEntry("/unisys_ca_license.txt");
        try {
            InputStream licenseInputStream = url.openStream();
            int bsize = licenseInputStream.available();
            byte[] barray = new byte[bsize];
            bsize = licenseInputStream.read(barray);
            licenseText = new String(barray);
        }
        catch (Exception exception) {
            licenseText = null;
        }
        return licenseText;
    }

    private static void markLicense() {
        FileOutputStream fout = null;
        try {
            File f = LicensePlugin.getLicenseAgreed();
            fout = new FileOutputStream(f);
            fout.close();
        }
        catch (IOException iOException) {}
    }

    private static File getLicenseAgreed() {
        Location currentLocation = Platform.getConfigurationLocation();
        File ldir = new File(String.valueOf(currentLocation.getURL().getFile()) + '/' + LicensePlugin.getDefault().toString());
        if (!ldir.exists()) {
            ldir.mkdirs();
        }
        File lfile = new File(ldir, licenseAgreed);
        return lfile;
    }

    static class Identifier {
        private static final String DELIM = ". _-";
        private int major;
        private int minor;
        private int service;

        Identifier(int major, int minor, int service) {
            this.major = major;
            this.minor = minor;
            this.service = service;
        }

        Identifier(String versionString) {
            StringTokenizer tokenizer = new StringTokenizer(versionString, DELIM);
            if (tokenizer.hasMoreTokens()) {
                this.major = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                this.minor = Integer.parseInt(tokenizer.nextToken());
            }
            try {
                if (tokenizer.hasMoreTokens()) {
                    this.service = Integer.parseInt(tokenizer.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }

        boolean isGreaterEqualTo(Identifier minimum) {
            if (this.major < minimum.major) {
                return false;
            }
            if (this.major > minimum.major) {
                return true;
            }
            if (this.minor < minimum.minor) {
                return false;
            }
            if (this.minor > minimum.minor) {
                return true;
            }
            return this.service >= minimum.service;
        }
    }
}

